@extends('layouts.main')
@section('page-title')
    {{ __('Landing Page') }}
@endsection
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('home')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item">{{__('Landing Page')}}</li>
@endsection

@php
    $settings = \Modules\LandingPage\Entities\LandingPageSetting::settings();
    $logo=\App\Models\Utility::get_file('uploads/landing_page_image');
@endphp



@push('pagescript')

<script src="{{ Module::asset('LandingPage:Resources/assets/js/plugins/tinymce.min.js')}}" referrerpolicy="origin"></script>


@endpush

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('home')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item">{{__('Landing Page')}}</li>
@endsection


@section('content')
<div class="dash-container">
    <div class="dash-content">
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <div class="page-header-title">
                            <h4 class="m-b-10">{{ __('Landing Page') }}</h4>
                        </div>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__('Dashboard')}}</a></li>
                            <li class="breadcrumb-item">{{__('Landing Page')}}</li>
                        </ul>
                    </div>
                    <div class="col-md-6 d-flex justify-content-end text-right">

                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="row">
                    <div class="col-xl-3">
                        <div class="card sticky-top" style="top:30px">
                            <div class="list-group list-group-flush" id="useradd-sidenav">

                                @include('landingpage::layouts.tab')


                            </div>
                        </div>
                    </div>

                    <div class="col-xl-9">
                        {{--  Start for all settings tab --}}


                            <div class="card">
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-lg-10 col-md-10 col-sm-10">
                                            <h5>{{ __('Discover') }}</h5>
                                        </div>
                                    </div>
                                </div>

                                {{ Form::open(array('route' => 'discover.store', 'method'=>'post', 'enctype' => "multipart/form-data")) }}
                                    @csrf
                                    <div class="card-body">
                                        <div class="row">

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{ Form::label('Heading', __('Heading'), ['class' => 'form-label']) }}
                                                    {{ Form::text('discover_heading',$settings['discover_heading'], ['class' => 'form-control ', 'placeholder' => __('Enter Heading')]) }}
                                                    @error('mail_host')
                                                    <span class="invalid-mail_driver" role="alert">
                                                            <strong class="text-danger">{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{ Form::label('Description', __('Description'), ['class' => 'form-label']) }}
                                                    {{ Form::text('discover_description', $settings['discover_description'], ['class' => 'form-control', 'placeholder' => __('Enter Description')]) }}
                                                    @error('mail_port')
                                                    <span class="invalid-mail_port" role="alert">
                                                            <strong class="text-danger">{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{ Form::label('Live Demo Link', __('Live Demo Link'), ['class' => 'form-label']) }}
                                                    {{ Form::text('discover_live_demo_link', $settings['discover_live_demo_link'], ['class' => 'form-control', 'placeholder' => __('Enter Link')]) }}
                                                    @error('discover_live_demo_link')
                                                    <span class="invalid-mail_port" role="alert">
                                                            <strong class="text-danger">{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {{ Form::label('Buy Now Link', __('Buy Now Link'), ['class' => 'form-label']) }}
                                                    {{ Form::text('discover_buy_now_link', $settings['discover_buy_now_link'], ['class' => 'form-control', 'placeholder' => __('Enter Link')]) }}
                                                    @error('discover_buy_now_link')
                                                    <span class="invalid-mail_port" role="alert">
                                                            <strong class="text-danger">{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="card-footer text-end">
                                        <button class="btn btn-print-invoice btn-primary m-r-10" type="submit" >{{ __('Save Changes') }}</button>
                                    </div>
                                {{ Form::close() }}

                            </div>


                            <div class="card">
                                <div class="card-header">
                                    <div class="row align-items-center">
                                        <div class="col-lg-9 col-md-9 col-sm-9">
                                            {{-- <h5>{{ __('Menu Bar') }}</h5> --}}
                                        </div>
                                        <div class="col-lg-3 col-md-3 col-sm-3 justify-content-end d-flex">
                                            <a data-size="lg" data-url="{{ route('discover_create') }}" data-ajax-popup="true"  data-bs-toggle="tooltip" title="{{__('Discover Feature Create')}}"  class="btn btn-sm btn-primary">
                                                <i class="ti ti-plus text-light"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">

                                    {{-- <div class="justify-content-end d-flex">

                                        <a data-size="lg" data-url="{{ route('users.create') }}" data-ajax-popup="true"  data-bs-toggle="tooltip" title="{{__('Create')}}"  class="btn btn-sm btn-primary">
                                            <i class="ti ti-plus text-light"></i>
                                        </a>
                                    </div> --}}

                                    <div class="table-responsive">
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th>{{__('No')}}</th>
                                                    <th>{{__('Name')}}</th>
                                                    <th>{{__('Action')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            @if (is_array($discover_of_features) || is_object($discover_of_features))
                                            @php
                                                    $no = 1
                                                @endphp
                                                    @foreach ($discover_of_features as $key => $value)
                                                        <tr>
                                                            <td>{{ $no++ }}</td>
                                                            <td>{{ $value['discover_heading'] }}</td>
                                                            <td>
                                                                <span>
                                                                    <div class="action-btn bg-primary ms-2">
                                                                            <a href="#" class="mx-3 btn btn-sm align-items-center" data-url="{{ route('discover_edit',$key) }}" data-ajax-popup="true" data-title="{{__('Edit Page')}}" data-size="lg" data-bs-toggle="tooltip"  title="{{__('Edit')}}" data-original-title="{{__('Edit')}}">
                                                                            <i class="ti ti-pencil text-white"></i>
                                                                        </a>
                                                                    </div>
                                                                    <div class="action-btn bg-danger ms-2">
                                                                        {!! Form::open(['method' => 'GET', 'route' => ['discover_delete', $key],'id'=>'delete-form-'.$key]) !!}
                                                                            <a href="#" class="mx-3 btn btn-sm align-items-center show_confirm">
                                                                                <i class="ti ti-trash text-white"></i>
                                                                            </a>
                                                                        {!! Form::close() !!}
                                                                    </div>
                                                                </span>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>




                        {{--  End for all settings tab --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection





